<?php
/***************************************************************************
*                                                                          *
*   (c) 2004 Vladimir V. Kalynyak, Alexey V. Vinokurov, Ilya M. Shalnev    *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

if (!defined('BOOTSTRAP')) { die('Access denied'); }

/*
 * Static options
 */

define('NEW_FEATURE_GROUP_ID', 'OG');

// These constants define when select box with categories list should be replaced with picker
define('CATEGORY_THRESHOLD', 100); // if number of categories less than this value, all categories will be retrieved, otherwise subcategories will be retrieved by ajax
define('CATEGORY_SHOW_ALL', 100);  // if number of categories less than this value, categories tree will be expanded

// These constants define when select box with pages list should be replaced with picker
define('PAGE_THRESHOLD', 40); // if number of pages less than this value, all pages will be retrieved, otherwise subpages will be retrieved by ajax
define('PAGE_SHOW_ALL', 100); // if number of pages less than this value, pages tree will be expanded

// These constants define when select box with product feature variants list should be replaced with picker
define('PRODUCT_FEATURE_VARIANTS_THRESHOLD', 40); // if number of product feature variants less than this value, all product feature variants will be retrieved, otherwise product features variants will be retrieved by ajax

// Maximum number of recently viewed products, stored in session
define('MAX_RECENTLY_VIEWED', 10);

// The maximum allowed value of the "Initial order ID value" in Settings: General
define('MAX_INITIAL_ORDER_ID', 10000000);

// Number of product features per page to display on product details page in admin panel
define('PRODUCT_FEATURES_THRESHOLD', 50);

// Week days
define('SUNDAY',    0);
define('MONDAY',    1);
define('TUESDAY',   2);
define('WEDNESDAY', 3);
define('THURSDAY',  4);
define('FRIDAY',    5);
define('SATURDAY',  6);

// statuses definitions
define('STATUSES_ORDER', 'O');
define('STATUSES_SHIPMENT', 'S');

/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::INCOMPLETED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::INCOMPLETED
 */
define('STATUS_INCOMPLETED_ORDER', 'N');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::PARENT instead.
 *
 * @see \Tygh\Enum\OrderStatuses::PARENT
 */
define('STATUS_PARENT_ORDER', 'T');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::BACKORDERED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::BACKORDERED
 */
define('STATUS_BACKORDERED_ORDER', 'B');
/**
 * @deprecated Deprecated since 4.14.1. Use \Tygh\Enum\OrderStatuses::CANCELED instead.
 *
 * @see \Tygh\Enum\OrderStatuses::CANCELED
 */
define('STATUS_CANCELED_ORDER', 'I');

//Login statuses
define('LOGIN_STATUS_USER_NOT_FOUND', '0');
define('LOGIN_STATUS_OK', '1');
define('LOGIN_STATUS_USER_DISABLED', '2');

// usergroup definitions
define('ALLOW_USERGROUP_ID_FROM', 3);
define('ALL_USERGROUPS', -1);
define('USERGROUP_ALL', 0);
define('USERGROUP_GUEST', 1);
define('USERGROUP_REGISTERED', 2);

// Authentication settings
define('USER_PASSWORD_LENGTH', '8');
define('USER_ONE_TIME_PASSWORD_LENGTH', 6);
define('USER_ONE_TIME_PASSWORD_ATTEMPTS', 5);

// Recovery password settings
define('RECOVERY_PASSWORD_EKEY_TYPE', 'R');
define('RECOVERY_PASSWORD_EKEYS_LIMIT', 3);
define('RECOVERY_PASSWORD_TTL', 900);

// SEF urls delimiter
define('SEO_DELIMITER', '-');

// Number of seconds in one hour (for different calculations)
define('SECONDS_IN_HOUR', 60 * 60); // one hour

// Number of seconds in one day (for different calculations)
define('SECONDS_IN_DAY', SECONDS_IN_HOUR * 24); // one day

// Live time for permanent cookies (currency, language, etc...)
define('COOKIE_ALIVE_TIME', SECONDS_IN_DAY * 7); // one week

// Session live time
define('SESSION_ALIVE_TIME', SECONDS_IN_HOUR * 2); // 2 hours

// Sessions storage live time
define('SESSIONS_STORAGE_ALIVE_TIME',  SECONDS_IN_DAY * 7 * 2); // 2 weeks

// Number of seconds after last session update, while user considered as online
define('SESSION_ONLINE', 60 * 5); // 5 minutes

// Number of seconds before installation script will be redirected to itself to avoid server timeouts
define('INSTALL_DB_EXECUTION', SECONDS_IN_HOUR); // 1 hour

//Uncomment to enable the developer tools: debugger, PHP and SQL loggers, etc.
//define('DEBUG_MODE', true);

//Uncomment to enable error reporting.
//define('DEVELOPMENT', true);

// Theme description file name
define('THEME_MANIFEST', 'manifest.json');
define('THEME_MANIFEST_INI', 'manifest.ini');

// Controller return statuses
define('CONTROLLER_STATUS_REDIRECT', 302);
define('CONTROLLER_STATUS_OK', 200);
define('CONTROLLER_STATUS_NO_CONTENT', 204);
define('CONTROLLER_STATUS_NO_PAGE', 404);
define('CONTROLLER_STATUS_DENIED', 403);
define('CONTROLLER_STATUS_DEMO', 401);

define('INIT_STATUS_OK', 1);
define('INIT_STATUS_REDIRECT', 2);
define('INIT_STATUS_FAIL', 3);

define('PLACE_ORDER_STATUS_OK', 1);
define('PLACE_ORDER_STATUS_TO_CART', 2);
define('PLACE_ORDER_STATUS_DENIED', 3);

// Maximum number of items in "Last edited items" list (in the backend)
define('LAST_EDITED_ITEMS_COUNT', 10);

// Meta description auto generation
define('AUTO_META_DESCRIPTION', true);

// Database default tables prefix
define('DEFAULT_TABLE_PREFIX', 'cscart_');

define('CS_PHP_VERSION', phpversion());

// Product information
define('PRODUCT_NAME', 'Multi-Vendor');
define('PRODUCT_VERSION', '4.18.3');
define('PRODUCT_RELEASE_TIMESTAMP', 1728950400);
define('PRODUCT_STATUS', 'ACTIVE');


define('PRODUCT_EDITION', 'MULTIVENDOR');
define('PRODUCT_BUILD', '');


if (!defined('ACCOUNT_TYPE')) {
    define('ACCOUNT_TYPE', 'customer');
}

//Popularity rating
define('POPULARITY_VIEW', 3);
define('POPULARITY_ADD_TO_CART', 5);
define('POPULARITY_DELETE_FROM_CART', 5);
define('POPULARITY_BUY', 10);

define('MAILING_LIST_ID', 1);

// Session options
// define('SESS_VALIDATE_IP', true); // link session ID with ip address
define('SESS_VALIDATE_UA', true); // link session ID with user-agent

define('BILLING_ADDRESS_PREFIX', 'b');
define('SHIPPING_ADDRESS_PREFIX', 's');

define('DB_MAX_ROW_SIZE', 10000);
define('DB_ROWS_PER_PASS', 400);

//User data type for admin theme mode
define('BACKOFFICE_COLOR_SCHEME', 'T');

/*
 * Dynamic options
 */
$config = array();

$config['dir'] = array(
    'root' => DIR_ROOT,
    'functions' => DIR_ROOT . '/app/functions/',
    'lib' => DIR_ROOT . '/app/lib/',
    'addons' => DIR_ROOT . '/app/addons/',
    'design_frontend' => DIR_ROOT . '/design/themes/',
    'design_backend' => DIR_ROOT . '/design/backend/',
    'payments' => DIR_ROOT . '/app/payments/',
    'schemas' => DIR_ROOT . '/app/schemas/',
    'themes_repository' => DIR_ROOT . '/var/themes_repository/',
    'database' => DIR_ROOT . '/var/database/',
    'var' => DIR_ROOT . '/var/',
    'upgrade' => DIR_ROOT . '/var/upgrade/',
    'cache_templates' => DIR_ROOT . '/var/cache/templates/',
    'cache_mail_templates' => DIR_ROOT . '/var/cache/templates/mail/',
    'cache_twig_templates' => DIR_ROOT . '/var/cache/templates/twig/',
    'cache_registry' => DIR_ROOT . '/var/cache/registry/',
    'files' => DIR_ROOT . '/var/files/',
    'cache_misc' => DIR_ROOT . '/var/cache/misc/',
    'cache_static' => DIR_ROOT . '/var/cache/static/',
    'layouts' => DIR_ROOT . '/var/layouts/',
    'snapshots' => DIR_ROOT . '/var/snapshots/',
    'lang_packs' => DIR_ROOT . '/var/langs/',
    'certificates' => DIR_ROOT . '/var/certificates/',
    'store_import' => DIR_ROOT . '/var/store_import/',
    'backups' => DIR_ROOT . '/var/backups/',
);

// List of forbidden file extensions (for uploaded files)
$config['forbidden_file_extensions'] = array (
    'php',
    'php3',
    'pl',
    'com',
    'exe',
    'bat',
    'cgi',
    'htaccess',
    'svg',
);

$config['forbidden_mime_types'] = array (
    'text/x-php',
    'text/x-perl',
    'text/x-python',
    'text/x-shellscript',
    'application/x-executable',
    'application/x-ms-dos-executable',
    'application/x-cgi',
    'application/x-extension-htaccess',
    'application/x-msdownload',
    'image/svg+xml',
);

$config['allowed_image_extensions'] = [
    'jpg',
    'jpeg',
    'png',
    'gif',
    'ico',
    'webp',
];

$config['sanitize_user_html_allowed_iframe_domains'] = [
    'www.youtube.com',
    'www.youtube-nocookie.com',
    'player.vimeo.com'
];

$config['js_css_cache_msg'] = "/*
ATTENTION! Please do not modify this file, it's auto-generated and all your changes will be lost.
The complete list of files it's generated from:
[files]
*/

";

$config['base_theme'] = 'responsive';

// FIXME: backward compatibility
// Updates server address
$config['updates_server'] = 'https://updates.cs-cart.com';

// external resources, related to product
$config['resources'] = array(
    'docs_url'                      => 'https://docs.cs-cart.com/4.18.x/',
    'knowledge_base'                => 'https://docs.cs-cart.com/4.18.x/install/index.html',
    'faq'                           => 'https://www.cs-cart.com/faq.html',
    'updates_server'                => 'https://updates.cs-cart.com',
    'twitter'                       => 'cscart',
    'feedback_api'                  => 'https://helpdesk.cs-cart.com/index.php?dispatch=feedback',
    'product_url'                   => 'https://www.cs-cart.com',
    'helpdesk_url'                  => 'https://helpdesk.cs-cart.com/helpdesk',
    'license_url'                   => 'https://www.cs-cart.com/licenses.html',
    'ultimate_license_url'          => 'https://www.cs-cart.com/cs-cart-ultimate-license.html',
    'standard_license_url'          => 'https://www.cs-cart.com/cs-cart-license.html',
    'download'                      => 'https://www.cs-cart.com/download-multivendor.html',
    'demo_product_buy_url'          => 'https://helpdesk.cs-cart.com/multi-vendor-licenses.html',
    'mve_plus_license_url'          => 'https://www.cs-cart.com/multi-vendor-plus-license.html',
    'mve_ultimate_license_url'      => 'https://www.cs-cart.com/multi-vendor-ultimate-license.html',
    'marketplace_url'               => 'https://marketplace.cs-cart.com',
    'admin_protection_url'          => 'https://docs.cs-cart.com/4.18.x/install/security.html#step-1-rename-admin-php',
    'widget_mode_url'               => 'https://docs.cs-cart.com/4.18.x/user_guide/look_and_feel/layouts/widget_mode/index.html',
    'developers_catalog'            => 'https://marketplace.cs-cart.com/developers-catalog.html',
    'upgrade_center_specialist_url' => 'https://marketplace.cs-cart.com/developers-catalog.html?services=M',
    'upgrade_center_team_url'       => 'https://www.cs-cart.com/index.php?dispatch=communication.tickets&submit_ticket=Y',
    'kb_https_failed_url'           => 'https://docs.cs-cart.com/4.18.x/install/possible_issues/secure_connection_failed.html',
    'curl_error_interpretation'     => 'https://curl.haxx.se/libcurl/c/libcurl-errors.html',
    'product_buy_url'               => 'https://www.cs-cart.com/multivendor.html?utm_source=trial',
    'forum'                         => 'https://forum.cs-cart.com/',
    'bug_tracker_url'               => 'https://forum.cs-cart.com/index.php?app=tracker&module=post&section=post&do=postnew&pid=11&new_module_versions_id=138',
    'core_addons_supplier_url'      => 'https://helpdesk.cs-cart.com',
    'docs_guideline'                => 'https://docs.cs-cart.com/4.18.x/developer_guide/getting_started/guidelines.html',
    'translate'                     => 'https://translate.cs-cart.com',
    'changelog_url'                 => 'https://docs.cs-cart.com/latest/history/index.html',
    'video_tutorials'               => 'https://www.cs-cart.com/cs-cart-video-tutorials.html',
);

$config['lazy_thumbnails'] = array(
    'max_width'  => 1280,
    'max_height' => 720
);

// Enable UI components
$config['simple_dashboard'] = true;
$config['enable_quick_menu'] = false;

// Debugger token
$config['debugger_token'] = 'debug';
$config['allowed_pack_exts'] = ['tgz', 'gz', 'zip'];

$config['helpdesk'] = [
    'url'           => 'https://helpdesk.cs-cart.com',
    'client_id'     => 'cs-cart',
    'client_secret' => 'd3d407a7096a56fa127ce9109ba1d5aa2afb8bb6',
];

// API key for Alpha Vantage (exchange rates) -> https://www.alphavantage.co/support/
$config['alpha_vantage_api_key'] = 'X24PW1QRZI0I3UAO';

// Get local configuration
require_once($config['dir']['root'] . '/config.local.php');

// Backward compatibility
if (!empty($config['saas_uid']) && empty($config['store_prefix'])) {
    $config['store_prefix'] = $config['saas_uid'];
}

// Define host directory depending on the current connection
$config['current_path'] = (defined('HTTPS')) ? $config['https_path'] : $config['http_path'];

$config['http_location'] = 'http://' . $config['http_host'] . $config['http_path'];
$config['https_location'] = 'https://' . $config['https_host'] . $config['https_path'];
$config['current_location'] = (defined('HTTPS')) ? $config['https_location'] : $config['http_location'];
$config['current_host'] = (defined('HTTPS')) ? $config['https_host'] : $config['http_host'];

return $config;
